

db = db or {}

troopsPath = db_path.. 'troops/'

function troop(name, nativeName, picture)
    local res = {};
    res.name = name;
    res.nativeName = nativeName;
    res.picture = picture;
    return res;
end;

-- TODO: remove oldId after all data in old format will be converted
-- to new format
local function country(name, oldId, shortname, flag, id, units, callsigns, ranks, awards, troops, rect)
  local res = {};
  
  res.Name = name;
  res.OldID = oldId;
  res.ShortName = shortname;
  res.flag = flag;
  res.WorldID = id;
  res.Units = units;
  res.CallNames = callsigns;
  res.Ranks = ranks or {};
  res.Awards = awards or {};
  res.rect = rect;
  
  res.rank_by_name = {}; 
  res.award_by_name = {};
  res.troop_by_name = {};
  
    for i = 1, #res.Awards do
        res.Awards[i].picture = oldId .. '/awards/' .. res.Awards[i].picture;
        res.Awards[i].countryID = id;
        res.award_by_name[res.Awards[i].name] = res.Awards[i];
    end;

    for i = 1, #res.Ranks do
        res.Ranks[i].stripes = oldId .. '/stripes.png';
        res.rank_by_name[res.Ranks[i].name] = res.Ranks[i];
    end;

    local path = troopsPath .. troops
    local f, err = loadfile(path)
    if f then
        local env = {troop = troop, _ = _}
        setfenv(f, env);
        f();
        --print('troops for', name, 'loaded from', path )
        res.Troops = env.troops;
    else
		res.Troops = {}
        print('error loading troops', err)
    end;
    
    for i = 1, #res.Troops do
        res.Troops[i].picture = oldId .. '/troops/'..res.Troops[i].picture;
        res.troop_by_name[res.Troops[i].name] = res.Troops[i];
    end;
  
  table.insert(db.Countries, res);
  db.CountriesByName[res.OldID]	= res
end

local function callsign(index, clsid, name)
  local res = {};
  res.CLSID = clsid;
  res.Index = name;
  res.ID =  index;
  
  return res;
end

local function rank(name, nativeName, threshold, pictureRect) 
    local res = {};
    res.name = name;
    res.nativeName = nativeName;
    res.threshold = threshold;
    res.pictureRect = pictureRect;
    return res;
end;

local function award(name, nativeName, threshold, picture)
    local res = {};
    res.name = name;
    res.nativeName = nativeName;
    res.threshold = threshold;
    res.picture = picture;
    return res;
end;

local function troop(name, nativeName, picture)
    local res = {};
    res.name = name;
    res.nativeName = nativeName;
    res.picture = picture;
    return res;
end;

-- makes deep copy of all fields from source table to target table
local function copyTable(target, src)
    if not target then
        target = { }
    end
    for i,v in pairs(src) do
        if type(v) == 'table' then
            if not target[i] then
                target[i] = { }
            end
            copyTable(target[i], v)
        else
            target[i] = v
        end
    end
    return target
end

-- RUSSIA
local units = {}
	copyTable(units,db.default_units)

	cnt_unit( units.Planes.Plane, "Su-33");
	cnt_unit( units.Planes.Plane, "Su-25");
	cnt_unit( units.Planes.Plane, "MiG-29S");
	cnt_unit( units.Planes.Plane, "MiG-29A");
	cnt_unit( units.Planes.Plane, "Su-27");
	cnt_unit( units.Planes.Plane, "Su-25TM");
	cnt_unit( units.Planes.Plane, "Su-25T");
	cnt_unit( units.Planes.Plane, "MiG-31");
	cnt_unit( units.Planes.Plane, "MiG-27K");
	cnt_unit( units.Planes.Plane, "Su-30");
	cnt_unit( units.Planes.Plane, "Tu-160");
	cnt_unit( units.Planes.Plane, "Su-34");
	cnt_unit( units.Planes.Plane, "Tu-95MS");
	cnt_unit( units.Planes.Plane, "Tu-142");
	cnt_unit( units.Planes.Plane, "MiG-25PD");
	cnt_unit( units.Planes.Plane, "Tu-22M3");
	cnt_unit( units.Planes.Plane, "A-50");
	cnt_unit( units.Planes.Plane, "Yak-40");
	cnt_unit( units.Planes.Plane, "An-26B");
	cnt_unit( units.Planes.Plane, "An-30M");
	cnt_unit( units.Planes.Plane, "Su-17M4");
	cnt_unit( units.Planes.Plane, "MiG-23MLD");
	cnt_unit( units.Planes.Plane, "MiG-25RBT");
	cnt_unit( units.Planes.Plane, "Su-24M");
	cnt_unit( units.Planes.Plane, "Su-24MR");
	cnt_unit( units.Planes.Plane, "IL-78M");
	cnt_unit( units.Planes.Plane, "IL-76MD");
	cnt_unit( units.Planes.Plane, "L-39ZA");
	cnt_unit( units.Planes.Plane, "P-51D");

	cnt_unit( units.Ships.Ship, "KUZNECOW");
	cnt_unit( units.Ships.Ship, "MOSCOW");
	cnt_unit( units.Ships.Ship, "PIOTR");
	cnt_unit( units.Ships.Ship, "ELNYA");
	cnt_unit( units.Ships.Ship, "ALBATROS");
	cnt_unit( units.Ships.Ship, "REZKY");
	cnt_unit( units.Ships.Ship, "MOLNIYA");
	cnt_unit( units.Ships.Ship, "KILO");
	cnt_unit( units.Ships.Ship, "SOM");
	cnt_unit( units.Ships.Ship, "ZWEZDNY");
	cnt_unit( units.Ships.Ship, "NEUSTRASH");
	cnt_unit( units.Ships.Ship, "Dry-cargo ship-1");
	cnt_unit( units.Ships.Ship, "Dry-cargo ship-2");

	cnt_unit( units.Cars.Car, "BTR-80");
	cnt_unit( units.Cars.Car, "1L13 EWR");
	cnt_unit( units.Cars.Car, "55G6 EWR");
	cnt_unit( units.Cars.Car, "S-300PS 40B6M tr");
	cnt_unit( units.Cars.Car, "S-300PS 40B6MD sr");
	cnt_unit( units.Cars.Car, "S-300PS 64H6E sr");
	cnt_unit( units.Cars.Car, "S-300PS 5P85C ln");
	cnt_unit( units.Cars.Car, "S-300PS 5P85D ln");
	cnt_unit( units.Cars.Car, "SA-11 Buk SR 9S18M1");
	cnt_unit( units.Cars.Car, "SA-11 Buk CC 9S470M1");
	cnt_unit( units.Cars.Car, "SA-11 Buk LN 9A310M1");
	cnt_unit( units.Cars.Car, "Kub 1S91 str");
	cnt_unit( units.Cars.Car, "Kub 2P25 ln");
	cnt_unit( units.Cars.Car, "Osa 9A33 ln");
	cnt_unit( units.Cars.Car, "Strela-1 9P31");
	cnt_unit( units.Cars.Car, "Strela-10M3");
	cnt_unit( units.Cars.Car, "Dog Ear radar");
	cnt_unit( units.Cars.Car, "Tor 9A331");
	cnt_unit( units.Cars.Car, "2S6 Tunguska");
	cnt_unit( units.Cars.Car, "ZSU-23-4 Shilka");
	cnt_unit( units.Cars.Car, "SAU Msta");
	cnt_unit( units.Cars.Car, "SAU Akatsia");
	cnt_unit( units.Cars.Car, "SAU 2-C9");
	cnt_unit( units.Cars.Car, "ATMZ-5");
	cnt_unit( units.Cars.Car, "ATZ-10");
	cnt_unit( units.Cars.Car, "BMD-1");
	cnt_unit( units.Cars.Car, "BMP-1");
	cnt_unit( units.Cars.Car, "BMP-2");
	cnt_unit( units.Cars.Car, "BRDM-2");
	cnt_unit( units.Cars.Car, "Grad-URAL");
	cnt_unit( units.Cars.Car, "Smerch");
	cnt_unit( units.Cars.Car, "T-80UD");
	cnt_unit( units.Cars.Car, "UAZ-469");
	cnt_unit( units.Cars.Car, "Ural-375");
	cnt_unit( units.Cars.Car, "Ural-375 PBU");
	cnt_unit( units.Cars.Car, "IKARUS Bus");
	cnt_unit( units.Cars.Car, "VAZ Car");
	cnt_unit( units.Cars.Car, "Trolley bus");
	cnt_unit( units.Cars.Car, "KAMAZ Truck");
	cnt_unit( units.Cars.Car, "LAZ Bus");
	cnt_unit( units.Cars.Car, "SAU Gvozdika");
	cnt_unit( units.Cars.Car, "BMP-3");
	cnt_unit( units.Cars.Car, "BTR_D");
	cnt_unit( units.Cars.Car, "S-300PS 54K6 cp");
	cnt_unit( units.Cars.Car, "GAZ-3307");
	cnt_unit( units.Cars.Car, "GAZ-66");
	cnt_unit( units.Cars.Car, "GAZ-3308");
	cnt_unit( units.Cars.Car, "MAZ-6303");
	cnt_unit( units.Cars.Car, "ZIL-4331");
	cnt_unit( units.Cars.Car, "SKP-11");
	cnt_unit( units.Cars.Car, "Ural-4320T");
	cnt_unit( units.Cars.Car, "Ural-4320-31");
	cnt_unit( units.Cars.Car, "Ural ATsP-6");
	cnt_unit( units.Cars.Car, "ZiL-131 APA-80");
	cnt_unit( units.Cars.Car, "ZIL-131 KUNG");
	cnt_unit( units.Cars.Car, "Ural-4320 APA-5D");
	cnt_unit( units.Cars.Car, "ZU-23 Emplacement");
	cnt_unit( units.Cars.Car, "ZU-23 Emplacement Closed");
	cnt_unit( units.Cars.Car, "Ural-375 ZU-23");
	cnt_unit( units.Cars.Car, "MTLB");
	cnt_unit( units.Cars.Car, "T-72B");
	cnt_unit( units.Cars.Car, "SA-18 Igla-S manpad");
	cnt_unit( units.Cars.Car, "SA-18 Igla-S comm");
	cnt_unit( units.Cars.Car, "T-55");
	cnt_unit( units.Cars.Car, "Paratrooper RPG-16");
	cnt_unit( units.Cars.Car, "Paratrooper AKS-74");
	cnt_unit( units.Cars.Car, "Boman");
	cnt_unit( units.Cars.Car, "2B11 mortar");
	cnt_unit( units.Cars.Car, "5p73 s-125 ln");
	cnt_unit( units.Cars.Car, "snr s-125 tr");
	cnt_unit( units.Cars.Car, "p-19 s-125 sr");
    cnt_unit( units.Cars.Car, "Infantry AK");
	cnt_unit( units.Cars.Car, "T-90");

	cnt_unit( units.Helicopters.Helicopter, "Mi-24V");
	cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
	cnt_unit( units.Helicopters.Helicopter, "Mi-26");
	cnt_unit( units.Helicopters.Helicopter, "Ka-27");
	cnt_unit( units.Helicopters.Helicopter, "Mi-28N");
	cnt_unit( units.Helicopters.Helicopter, "UH-1H");
	
country(_("Russia"), "Russia", "RUS", "Russia.png", 0, units,
  {
    callsign(1, "{63F96C45-0053-4b82-91A3-484E101297C7}", "0"),
    callsign(2, "{99614DB6-5B25-465e-87BC-528CFB253784}", "1"),
    callsign(3, "{AC5C879B-E065-40fe-B160-0CDAE7FC011D}", "2"),
    callsign(4, "{99420485-7146-4286-9CB4-B6E362A13F8B}", "3"),
    callsign(5, "{A72AF054-195F-431c-978D-B519ACAFD997}", "4"),
    callsign(6, "{B2B919BB-55E4-4731-8AC1-CFDB14341407}", "5"),
    callsign(7, "{7FCB6479-44DB-42c2-9EC4-9F7197A06F79}", "6"),
    callsign(8, "{1C2F8D53-DDD8-41d8-A871-A7BAF1E957F5}", "7"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Courage Order', _('Courage Order'), 200, 'RUS-01-CourageOrder.png'),
    award('Medal of Courage',_('Medal of Courage'), 600, 'RUS-02-MeritMedal.png'),
    award('Nesterov Medal',_('Nesterov Medal'), 1000, 'RUS-03-NesterovMedal.png'),
    award('Military Serve Order',_('Military Serve Order'), 1400, 'RUS-04-MilitaryServe.png'),
    award('Georgy Cross-IV',_('Georgy Cross-IV'), 1800, 'RUS-05-GeorgyCross-4.png'),
    award('Medal For Merit To Fatherland-II with swords',_('Medal For Merit To Fatherland-II with swords'), 2200, 'RUS-06-ForMeritToFatherland-2.png'),
    award('Georgy Cross-I',_('Georgy Cross-I'), 2600, 'RUS-07-GeorgyCross-1.png'),
    award('Hero Gold Star',_('Hero Gold Star'), 3000, 'RUS-08-HeroStar.png'),
  },
  'Russia.lua',  
  {0,0,64,30}
);

--UKRAINE
local units = {}
	copyTable(units,db.default_units)

	cnt_unit( units.Planes.Plane, "Su-27");
	cnt_unit( units.Planes.Plane, "MiG-29A");
	cnt_unit( units.Planes.Plane, "MiG-29S");
	cnt_unit( units.Planes.Plane, "Su-17M4");
	cnt_unit( units.Planes.Plane, "Tu-95MS");
	cnt_unit( units.Planes.Plane, "Su-24M");
	cnt_unit( units.Planes.Plane, "Su-24MR");
	cnt_unit( units.Planes.Plane, "Su-25");
	cnt_unit( units.Planes.Plane, "MiG-25PD");
	cnt_unit( units.Planes.Plane, "An-26B");
	cnt_unit( units.Planes.Plane, "An-30M");
	cnt_unit( units.Planes.Plane, "MiG-23MLD");
	cnt_unit( units.Planes.Plane, "IL-78M");
	cnt_unit( units.Planes.Plane, "IL-76MD");
	cnt_unit( units.Planes.Plane, "MiG-27K");
	cnt_unit( units.Planes.Plane, "Tu-22M3");
	cnt_unit( units.Planes.Plane, "MiG-25RBT");
	cnt_unit( units.Planes.Plane, "Yak-40");
	cnt_unit( units.Planes.Plane, "L-39ZA");
	cnt_unit( units.Planes.Plane, "P-51D");
			
	cnt_unit( units.Ships.Ship, "ELNYA");
	cnt_unit( units.Ships.Ship, "ALBATROS");
	cnt_unit( units.Ships.Ship, "MOLNIYA");
	cnt_unit( units.Ships.Ship, "KILO");
	cnt_unit( units.Ships.Ship, "ZWEZDNY");
	cnt_unit( units.Ships.Ship, "Dry-cargo ship-1");
	cnt_unit( units.Ships.Ship, "Dry-cargo ship-2");
	cnt_unit( units.Ships.Ship, "REZKY");

	cnt_unit( units.Cars.Car, "BTR-80");
	cnt_unit( units.Cars.Car, "1L13 EWR");
	cnt_unit( units.Cars.Car, "55G6 EWR");
	cnt_unit( units.Cars.Car, "S-300PS 40B6M tr");
	cnt_unit( units.Cars.Car, "S-300PS 40B6MD sr");
	cnt_unit( units.Cars.Car, "S-300PS 64H6E sr");
	cnt_unit( units.Cars.Car, "S-300PS 5P85C ln");
	cnt_unit( units.Cars.Car, "S-300PS 5P85D ln");
	cnt_unit( units.Cars.Car, "SA-11 Buk SR 9S18M1");
	cnt_unit( units.Cars.Car, "SA-11 Buk CC 9S470M1");
	cnt_unit( units.Cars.Car, "SA-11 Buk LN 9A310M1");
	cnt_unit( units.Cars.Car, "Kub 1S91 str");
	cnt_unit( units.Cars.Car, "Kub 2P25 ln");
	cnt_unit( units.Cars.Car, "Osa 9A33 ln");
	cnt_unit( units.Cars.Car, "Strela-10M3");
	cnt_unit( units.Cars.Car, "Dog Ear radar");
	cnt_unit( units.Cars.Car, "Tor 9A331");
	cnt_unit( units.Cars.Car, "ZSU-23-4 Shilka");
	cnt_unit( units.Cars.Car, "SAU Msta");
	cnt_unit( units.Cars.Car, "SAU Akatsia");
	cnt_unit( units.Cars.Car, "SAU 2-C9");
	cnt_unit( units.Cars.Car, "ATMZ-5");
	cnt_unit( units.Cars.Car, "ATZ-10");
	cnt_unit( units.Cars.Car, "BMD-1");
	cnt_unit( units.Cars.Car, "BMP-1");
	cnt_unit( units.Cars.Car, "BMP-2");
	cnt_unit( units.Cars.Car, "BRDM-2");
	cnt_unit( units.Cars.Car, "Grad-URAL");
	cnt_unit( units.Cars.Car, "T-80UD");
	cnt_unit( units.Cars.Car, "UAZ-469");
	cnt_unit( units.Cars.Car, "Ural-375");
	cnt_unit( units.Cars.Car, "Ural-375 PBU");
	cnt_unit( units.Cars.Car, "IKARUS Bus");
	cnt_unit( units.Cars.Car, "VAZ Car");
	cnt_unit( units.Cars.Car, "Trolley bus");
	cnt_unit( units.Cars.Car, "KAMAZ Truck");
	cnt_unit( units.Cars.Car, "LAZ Bus");
	cnt_unit( units.Cars.Car, "SAU Gvozdika");
	cnt_unit( units.Cars.Car, "BTR_D");
	cnt_unit( units.Cars.Car, "S-300PS 54K6 cp");
	cnt_unit( units.Cars.Car, "GAZ-3307");
	cnt_unit( units.Cars.Car, "GAZ-3308");
	cnt_unit( units.Cars.Car, "GAZ-66");
	cnt_unit( units.Cars.Car, "ZIL-4331");
	cnt_unit( units.Cars.Car, "MAZ-6303");
	cnt_unit( units.Cars.Car, "SKP-11");
	cnt_unit( units.Cars.Car, "Ural-4320T");
	cnt_unit( units.Cars.Car, "Ural ATsP-6");
	cnt_unit( units.Cars.Car, "ZiL-131 APA-80");
	cnt_unit( units.Cars.Car, "ZIL-131 KUNG");
	cnt_unit( units.Cars.Car, "Ural-4320 APA-5D");
	cnt_unit( units.Cars.Car, "ZU-23 Emplacement");
	cnt_unit( units.Cars.Car, "ZU-23 Emplacement Closed");
	cnt_unit( units.Cars.Car, "Ural-375 ZU-23");
	cnt_unit( units.Cars.Car, "2S6 Tunguska");
	cnt_unit( units.Cars.Car, "Smerch");
	cnt_unit( units.Cars.Car, "Strela-1 9P31");
	cnt_unit( units.Cars.Car, "MTLB");
	cnt_unit( units.Cars.Car, "T-72B");
	cnt_unit( units.Cars.Car, "SA-18 Igla-S manpad");
	cnt_unit( units.Cars.Car, "SA-18 Igla-S comm");
	cnt_unit( units.Cars.Car, "T-55");
	cnt_unit( units.Cars.Car, "2B11 mortar");

	cnt_unit( units.Helicopters.Helicopter, "Mi-24V");
	cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
	cnt_unit( units.Helicopters.Helicopter, "Mi-26");
	cnt_unit( units.Helicopters.Helicopter, "Ka-27");
	cnt_unit( units.Helicopters.Helicopter, "UH-1H");
	
country(_("Ukraine"), "Ukraine", "UKR", "Ukraine.png", 1, units,
  {
    callsign(1, "{63F96C45-0053-4b82-91A3-484E101297C7}", "0"),
    callsign(2, "{99614DB6-5B25-465e-87BC-528CFB253784}", "1"),
    callsign(3, "{AC5C879B-E065-40fe-B160-0CDAE7FC011D}", "2"),
    callsign(4, "{99420485-7146-4286-9CB4-B6E362A13F8B}", "3"),
    callsign(5, "{A72AF054-195F-431c-978D-B519ACAFD997}", "4"),
    callsign(6, "{B2B919BB-55E4-4731-8AC1-CFDB14341407}", "5"),
    callsign(7, "{7FCB6479-44DB-42c2-9EC4-9F7197A06F79}", "6"),
    callsign(8, "{1C2F8D53-DDD8-41d8-A871-A7BAF1E957F5}", "7"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medal "Zakhystnyku Vitchyzny"', _('Medal "Zakhystnyku Vitchyzny"'), 200,  'UKR-01-ForDefenderOfFatherland.png'),
    award('Orden "Za Zaslugy III"', _('Orden "Za Zaslugy III"'), 600,  'UKR-02-ForMerit-III.png'),
    award('Orden "Za Zaslugy II"', _('Orden "Za Zaslugy II"'), 1000, 'UKR-03-ForMerit-II.png'),
    award('Orden "Za Zaslugy I"', _('Orden "Za Zaslugy I"'), 1400, 'UKR-04-ForMerit-I.png'),
    award('Zirka "Za Zaslugy"', _('Zirka "Za Zaslugy"'), 1800, 'UKR-05-ForMerit-Star.png'),
    award('Medal "Za Viyskovu Sluzhbu"', _('Medal "Za Viyskovu Sluzhbu"'), 2200, 'UKR-06-ForMilitaryService.png'),                                                    
    award('Orden "Za Muzhnist"', _('Orden "Za Muzhnist"'), 2600, 'UKR-07-OrderForCourage.png'),
    award('Zolota Zirka', _('Zolota Zirka'), 3000, 'UKR-08-GoldStar.png'),                                                       
  },                                         
  'Ukraine.lua',
  {0,390,64,30}
);

-- USA
local units = {}
	copyTable(units,db.default_units)

	cnt_unit( units.Planes.Plane, "A-10A");
	cnt_unit( units.Planes.Plane, "F-117A");
	cnt_unit( units.Planes.Plane, "C-17A");
	cnt_unit( units.Planes.Plane, "F-15C");
	cnt_unit( units.Planes.Plane, "F-15E");
	cnt_unit( units.Planes.Plane, "F-16C bl.52d");
	cnt_unit( units.Planes.Plane, "B-1B");
	cnt_unit( units.Planes.Plane, "B-52H");
	cnt_unit( units.Planes.Plane, "E-3A");
	cnt_unit( units.Planes.Plane, "KC-135");
	cnt_unit( units.Planes.Plane, "C-130");
	cnt_unit( units.Planes.Plane, "F-14A");
	cnt_unit( units.Planes.Plane, "S-3B");
	cnt_unit( units.Planes.Plane, "S-3B Tanker");
	cnt_unit( units.Planes.Plane, "F/A-18C");
	cnt_unit( units.Planes.Plane, "E-2C");
	cnt_unit( units.Planes.Plane, "F-16A");
	cnt_unit( units.Planes.Plane, "F-5E");
	cnt_unit( units.Planes.Plane, "RQ-1A Predator");
	cnt_unit( units.Planes.Plane, "P-51D");

	cnt_unit( units.Ships.Ship, "VINSON");
	cnt_unit( units.Ships.Ship, "PERRY");
	cnt_unit( units.Ships.Ship, "TICONDEROG");
	cnt_unit( units.Ships.Ship, "KUZNECOW");

	cnt_unit( units.Cars.Car, "M-2 Bradley");
	cnt_unit( units.Cars.Car, "M1097 Avenger");
	cnt_unit( units.Cars.Car, "Patriot str");
	cnt_unit( units.Cars.Car, "Patriot ln");
	cnt_unit( units.Cars.Car, "Patriot AMG");
	cnt_unit( units.Cars.Car, "Patriot EPP");
	cnt_unit( units.Cars.Car, "Patriot ECS");
	cnt_unit( units.Cars.Car, "Patriot cp");
	cnt_unit( units.Cars.Car, "Hawk sr");
	cnt_unit( units.Cars.Car, "Hawk tr");
	cnt_unit( units.Cars.Car, "Hawk ln");
	cnt_unit( units.Cars.Car, "Vulcan");
	cnt_unit( units.Cars.Car, "Hummer");
	cnt_unit( units.Cars.Car, "LAV-25");
	cnt_unit( units.Cars.Car, "AAV7");
	cnt_unit( units.Cars.Car, "M-113");
	cnt_unit( units.Cars.Car, "M-109");
	cnt_unit( units.Cars.Car, "M-1 Abrams");
	cnt_unit( units.Cars.Car, "MLRS");
	cnt_unit( units.Cars.Car, "M 818");
	cnt_unit( units.Cars.Car, "M48 Chaparral");
	cnt_unit( units.Cars.Car, "M1126 Stryker ICV");
	cnt_unit( units.Cars.Car, "M1128 Stryker MGS");
	cnt_unit( units.Cars.Car, "M1134 Stryker ATGM");
	cnt_unit( units.Cars.Car, "M6 Linebacker");
	cnt_unit( units.Cars.Car, "Stinger manpad");
	cnt_unit( units.Cars.Car, "Stinger comm");
	cnt_unit( units.Cars.Car, "Predator GCS");
	cnt_unit( units.Cars.Car, "Predator TrojanSpirit");
	cnt_unit( units.Cars.Car, "M1043 HMMWV Armament");
	cnt_unit( units.Cars.Car, "M1045 HMMWV TOW");
	cnt_unit( units.Cars.Car, "M978 HEMTT Tanker");
	cnt_unit( units.Cars.Car, "HEMTT TFFT");
	cnt_unit( units.Cars.Car, "Soldier M4");
	cnt_unit( units.Cars.Car, "Soldier M249");
	cnt_unit( units.Cars.Car, "2B11 mortar");
	
	cnt_unit( units.Helicopters.Helicopter, "AH-64A");
	cnt_unit( units.Helicopters.Helicopter, "AH-64D");
	cnt_unit( units.Helicopters.Helicopter, "AH-1W");
	cnt_unit( units.Helicopters.Helicopter, "UH-60A");
	cnt_unit( units.Helicopters.Helicopter, "CH-47D");
	cnt_unit( units.Helicopters.Helicopter, "SH-60B");
	cnt_unit( units.Helicopters.Helicopter, "CH-53E");
	cnt_unit( units.Helicopters.Helicopter, "OH-58D");
	cnt_unit( units.Helicopters.Helicopter, "UH-1H");
	cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
	
country(_("USA"), "USA", "USA", "USA.png", 2, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Air Medal', _('Air Medal'), 200, 'US-01-AirMedal.png'),
    award('Purple Heart', _('Purple Heart'), 600, 'US-02-PurpleHeart.png'),
    award('Bronze Star', _('Bronze Star'), 1000, 'US-03-BronzeStar.png'),
    award('Airmans Medal', _('Airmans Medal'), 1400, 'US-04-AirmansMedal.png'),
    award('Distinguished Flying Cross', _('Distinguished Flying Cross'), 1800, 'US-05-DistinguishedFlyingCross.png'),
    award('Silver Star', _('Silver Star'), 2200, 'US-06-SilverStar.png'),
    award('Air Force Cross', _('Air Force Cross'), 2600, 'US-07-AirForceCross.png'),
    award('Medal of Honour', _('Medal of Honour'), 3000, 'US-08-AirForceMedalOfHonour.png'),
  },
  'USA.lua',
  {0,30,64,30}
);

-- TURKEY
local units = {}
	copyTable(units,db.default_units)

        cnt_unit( units.Planes.Plane, "F-16C bl.50");
        cnt_unit( units.Planes.Plane, "F-4E");
        cnt_unit( units.Planes.Plane, "F-5E");
        cnt_unit( units.Planes.Plane, "C-130");
		cnt_unit( units.Planes.Plane, "P-51D");

        cnt_unit( units.Ships.Ship, "PERRY");

        cnt_unit( units.Cars.Car, "M-113");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "M 818");
        cnt_unit( units.Cars.Car, "M-60");
        cnt_unit( units.Cars.Car, "MLRS");
        cnt_unit( units.Cars.Car, "M1097 Avenger");
        cnt_unit( units.Cars.Car, "Vulcan");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "AAV7");
        cnt_unit( units.Cars.Car, "M48 Chaparral");
        cnt_unit( units.Cars.Car, "BTR-80");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "M978 HEMTT Tanker");
		cnt_unit( units.Cars.Car, "HEMTT TFFT");
        cnt_unit( units.Cars.Car, "Leopard1A3");

        cnt_unit( units.Helicopters.Helicopter, "UH-60A");
        cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
        cnt_unit( units.Helicopters.Helicopter, "AH-1W");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		
country(_("Turkey"), "Turkey", "TUR", "Turkey.png", 3, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Liakat Medal', _('Liakat Medal'), 200,  'TUR-01-Liakat_Medal.png'),
    award('Success Medal', _('Success Medal'), 600,  'TUR-02-Succes_Medal.png'),
    award('Superior Service Medal', _('Superior Service Medal'), 1200, 'TUR-03-Superior_Service.png'),
    award('Superior Braveness Medal', _('Superior Braveness Medal'), 1800, 'TUR-04-Superior_Braveness_Medal.png'),
    award('Service and Praise Medal', _('Service and Praise Medal'), 2400, 'TUR-05-Service_and_Praise_Medal.png'),
    award('Medal of Honour', _('Medal of Honour'), 3000, 'TUR-06-Honour_Medal.png'),                                                                           
  },                                         
  'Turkey.lua',
  {0,330,64,30}
);

-- GERMANY
local units = {}
	copyTable(units,db.default_units)

        cnt_unit( units.Planes.Plane, "MiG-29G");
        cnt_unit( units.Planes.Plane, "F-4E");
        cnt_unit( units.Planes.Plane, "Tornado IDS");
		cnt_unit( units.Planes.Plane, "P-51D");
		
        cnt_unit( units.Cars.Car, "M-113");
        cnt_unit( units.Cars.Car, "Patriot str");
        cnt_unit( units.Cars.Car, "Patriot ln");
		cnt_unit( units.Cars.Car, "Patriot AMG");
		cnt_unit( units.Cars.Car, "Patriot EPP");
		cnt_unit( units.Cars.Car, "Patriot ECS");
		cnt_unit( units.Cars.Car, "Patriot cp");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "Roland ADS");
        cnt_unit( units.Cars.Car, "Roland Radar");
        cnt_unit( units.Cars.Car, "Gepard");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "Leopard-2");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "Marder");
        cnt_unit( units.Cars.Car, "TPZ");
        cnt_unit( units.Cars.Car, "MLRS");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "M 818");
        cnt_unit( units.Cars.Car, "M978 HEMTT Tanker");
		cnt_unit( units.Cars.Car, "HEMTT TFFT");
		
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
	
country(_("Germany"), "Germany", "GER", "Germany.png", 6, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Ehrenmedaille', _('Ehrenmedaille'), 200,  'DE-01-Ehrenmedaille-Honor.png'),
    award('Ehrenkreuz', _('Ehrenkreuz'), 700,  'DE-02-Ehrenkreuze.png'),
    award('Ehrenkreuz in Silber', _('Ehrenkreuz in Silber'), 1200, 'DE-03-Silbernekreuze.png'),
    award('Ehrenkreuz in Gold', _('Ehrenkreuz in Gold'), 1800, 'DE-04-Goldenekreuze.png'),
    award('Bundesverdienstmedaille', _('Bundesverdienstmedaille'), 2400, 'DE-05-Bundesverdienstmedaille.png'),
    award('Bundesverdienstkreuz', _('Bundesverdienstkreuz'), 3000, 'DE-06-Bundesverdienstkreuz.png'),   
  },                                         
  'Germany.lua',
  {0,210,64,30}
);

-- CANADA
local units = {}
	copyTable(units,db.default_units)

        cnt_unit( units.Planes.Plane, "C-130");
		cnt_unit( units.Planes.Plane, "P-51D");
		cnt_unit( units.Planes.Plane, "F/A-18C");
			
        cnt_unit( units.Cars.Car, "M-113");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "LAV-25");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "M 818");
        cnt_unit( units.Cars.Car, "M978 HEMTT Tanker");
		cnt_unit( units.Cars.Car, "HEMTT TFFT");
        cnt_unit( units.Cars.Car, "Leopard1A3");
		
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		
country(_("Canada"), "Canada", "CAN", "Canada.png", 8, units, 
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medal of Bravery', _('Medal of Bravery'), 200,  'CA_01_Medal_of_Bravery.png'),
    award('Medal of Military Valour', _('Medal of Military Valour'), 600,  'CA_02_Medal_of_Military_Valour.png'),
    award('Meritorious Service Cross', _('Meritorious Service Cross'), 1000, 'CA_03_Meritorious_Service_Cross.png'),
    award('Star of Courage', _('Star of Courage'), 1400, 'CA_04_Star_of_Courage.png'),
    award('Star of Military Valour', _('Star of Military Valour'), 1800, 'CA_05_Star_of_Military_Valour.png'),
    award('The Order of Military Merit', _('The Order of Military Merit'), 2200, 'CA_06_The_Order_of_Military_Merit.png'),
    award('The Order of Canada', _('The Order of Canada'), 2600, 'CA_07_The_Order_of_Canada.png'),
    award('Cross of Valour', _('Cross of Valour'), 3000, 'CA_08_Cross_of_Valour.png'),            
  },                                      
  'Canada.lua',
  {0,90,64,30}
);

-- UK
local units = {}
	copyTable(units,db.default_units)

        cnt_unit( units.Planes.Plane, "Tornado GR4");
        cnt_unit( units.Planes.Plane, "C-130");
		cnt_unit( units.Planes.Plane, "P-51D");

        cnt_unit( units.Cars.Car, "MCV-80");
        cnt_unit( units.Cars.Car, "Challenger2");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "MLRS");
        cnt_unit( units.Cars.Car, "M 818");

        cnt_unit( units.Helicopters.Helicopter, "AH-64A");
        cnt_unit( units.Helicopters.Helicopter, "AH-64D");
        cnt_unit( units.Helicopters.Helicopter, "CH-47D");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		
country(_("UK"), "UK", "UK", "UK.png", 4, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('British Empire Medal', _('British Empire Medal'), 200,  'UK-01-British_Empire_Medal.png'),
    award('Air Force Medal', _('Air Force Medal'), 600,  'UK-02-Air_Force_Medal.png'),
    award('Distinguished Flying Medal', _('Distinguished Flying Medal'), 1000, 'UK-03-Distinguished_Flying_Medal.png'),
    award('Military Medal', _('Military Medal'), 1400, 'UK-04-Military_Medal.png'),
    award('Distinguished Conduct Medal', _('Distinguished Conduct Medal'), 1800, 'UK-05-Distiguished_Conduct_Medal.png'),
    award('Air Force Cross', _('Air Force Cross'), 2200, 'UK-06-Air_Force_Cross.png'),                                                               
    award('Distinguished Flying Cross', _('Distinguished Flying Cross'), 2600, 'UK-07-Distinguished_Flying_Cross.png'),
    award('Military Cross', _('Military Cross'), 3000, 'UK-08-Military_Cross.png'),                                                    
  },                                         
  'UK.lua',
  {0,360,64,30}
);

-- FRANCE
local units = {}
	copyTable(units,db.default_units)

        cnt_unit( units.Planes.Plane, "Mirage 2000-5");
        cnt_unit( units.Planes.Plane, "C-130");
		cnt_unit( units.Planes.Plane, "P-51D");
		
        cnt_unit( units.Cars.Car, "Leclerc");
        cnt_unit( units.Cars.Car, "MLRS");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "M 818");
		
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		
country(_("France"), "France", "FRA", "France.png", 5, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Croix de la bravoure', _('Croix de la bravoure'), 200,  'FR-01-Cross_of_Valour.png'),
    award('Medaille militaire', _('Medaille militaire'), 600,  'FR-02-Medal_Militaire.png'),
    award('Medaille du merite', _('Medaille du merite'), 1000, 'FR-03-Merit_Medal.png'),
    award('Croix du combattant', _('Croix du combattant'), 1400, 'FR-04-Combatant_Cross.png'),
    award([[Medaille de la defense de l'armee nationale]], _([[Medaille de la defense de l'armee nationale]]), 1800, 'FR-05-Army_National_Defence_Medal.png'),
    award('Ordre du merite', _('Ordre du merite'), 2200, 'FR-06-Merit_Order.png'),
    award('Croix de la liberte', _('Croix de la liberte'), 2600, 'FR-07-Liberty_Cross.png'),
    award([[Legion d'honneur]], _([[Legion d'honneur]]), 3000, 'FR-08-Legion_of_Honor.png'),            
  },                                         
  'France.lua',
  {0,150,64,30}
);

-- SPAIN
local units = {}
	copyTable(units,db.default_units)
			
        cnt_unit( units.Planes.Plane, "C-130");
		cnt_unit( units.Planes.Plane, "P-51D");
		cnt_unit( units.Planes.Plane, "F/A-18C");
			
        cnt_unit( units.Cars.Car, "M-113");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "Leopard-2");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "M 818");

		cnt_unit( units.Helicopters.Helicopter, "CH-47D");
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		
country(_("Spain"), "Spain", "SPN", "Spain.png", 9, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Cruz del Merito Aeronautico con distintivo azul', _('Cruz del Merito Aeronautico con distintivo azul'), 200,  'SP-01-Aeronautical_Merit_Cross_with_Blue_Ribbon.png'),
    award('Cruz del Merito Aeronautico con distintivo rojo', _('Cruz del Merito Aeronautico con distintivo rojo'), 800,  'SP-02-Aeronautical_Merit_Cross_with_Red_Ribbon.png'),
    award('Cruz de Guerra', _('Cruz de Guerra'), 1500, 'SP-03-War_Cross.png'),
    award('Medalla Militar Individual', _('Medalla Militar Individual'), 2200, 'SP-04-Individual_Military_Medal.png'),
    award('Cruz Laureada de San Fernando', _('Cruz Laureada de San Fernando'), 3000, 'SP-05-Laureate_Cross_of_Saint_Ferdinand.png'),        
  },                                         
  'Spain.lua',
  {0,420,64,30}
);

-- THE NETHERLANDS
local units = {}
	copyTable(units,db.default_units)

        cnt_unit( units.Planes.Plane, "C-130");
        cnt_unit( units.Planes.Plane, "F-16A MLU");
		cnt_unit( units.Planes.Plane, "P-51D");
			
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "Patriot str");
        cnt_unit( units.Cars.Car, "Patriot ln");
		cnt_unit( units.Cars.Car, "Patriot AMG");
		cnt_unit( units.Cars.Car, "Patriot EPP");
		cnt_unit( units.Cars.Car, "Patriot ECS");
        cnt_unit( units.Cars.Car, "Patriot cp");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "Leopard-2");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "MLRS");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "M 818");
        cnt_unit( units.Cars.Car, "Leopard1A3");
		
        cnt_unit( units.Helicopters.Helicopter, "AH-64A");     
        cnt_unit( units.Helicopters.Helicopter, "AH-64D");
        cnt_unit( units.Helicopters.Helicopter, "CH-47D");
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		
country(_("The Netherlands"), "The Netherlands", "NETH", "The Netherlands.png", 10, units, 
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Aviators Cross', _('Aviators Cross'), 200,  'NED-01-Aviators_Cross.png'),
    award('Hasselt Cross', _('Hasselt Cross'), 600,  'NED-02-Hasselt_Cross.png'),
    award('Lion III Class', _('Lion III Class'), 1000, 'NED-03-Lion_III_Class.png'),
    award('Long Service Decoration Bronze', _('Long Service Decoration Bronze'), 1400, 'NED-04-Long_Service_Decoration_Bronze.png'),                    
    award('Long Service Decoration Silver', _('Long Service Decoration Silver'), 1800, 'NED-05-Long_Service_Decoration_Silver.png'),                                    
    award('Military Order of William Knight', _('Military Order of William Knight'), 2200, 'NED-06-Military_Order_of_William_Knight.png'),
    award('Order of the House of Nassau', _('Order of the House of Nassau'), 2600, 'NED-07-Order_of_the_House_of_Nassau.png'),                                    
    award('Order of the House of Nassau-2', _('Order of the House of Nassau-2'), 3000, 'NED-08-Order_of_the_House_of_Nassau-2.png'),                                            
  },                                         
  'The Netherlands.lua',
  {0,300,64,30}  
);

-- BELGIUM
local units = {}
	copyTable(units,db.default_units)

        cnt_unit( units.Planes.Plane, "C-130");
        cnt_unit( units.Planes.Plane, "F-16A MLU");
		cnt_unit( units.Planes.Plane, "P-51D");
			
        cnt_unit( units.Cars.Car, "M-113");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "M 818");
		
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		
country(_("Belgium"), "Belgium", "BEL", "Belgium.png", 11, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medaille van militaire verdienste ', _('Medaille van militaire verdienste '), 200,  'BEL-01-Officer_of_the_Order_of_Leopold-1.png'),
    award('Erekruis voor militaire dienst in het buitenland ', _('Erekruis voor militaire dienst in het buitenland '), 600,  'BEL-02-Officer_of_the_Order_of_the_Crown.png'),
    award('Militair Kruis 2de Klas', _('Militair Kruis 2de Klas'), 1000, 'BEL-03-Officer_of_the_Order_of_Leopold-2.png'),
    award('Militair Kruis 1ste Klas', _('Militair Kruis 1ste Klas'), 1400, 'BEL-04-Knight_of_the_Order_of_Leopold.png'),
    award('Ridder in de Leopoldsorde', _('Ridder in de Leopoldsorde'), 1800, 'BEL-05-Military_Cross_1st_Class.png'),
    award('Officier in de Orde van Leopold II', _('Officier in de Orde van Leopold II'), 2200, 'BEL-06-Military_Cross_2nd_Class.png'),
    award('Officier in de Kroonorde', _('Officier in de Kroonorde'), 2600, 'BEL-07-Military_Cross_for_Foreign_Service.png'),
    award('Officier in de Leopoldsorde', _('Officier in de Leopoldsorde'), 3000, 'BEL-08-Medal_for_Military_Merit.png'),          
  },
  'Belgium.lua',
  {0,60,64,30}
);

-- NORWAY
local units = {}
	copyTable(units,db.default_units)

		cnt_unit( units.Planes.Plane, "C-130");
		cnt_unit( units.Planes.Plane, "F-16A MLU");
		cnt_unit( units.Planes.Plane, "P-51D");

        cnt_unit( units.Cars.Car, "M-113");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "MLRS");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "M 818");
        cnt_unit( units.Cars.Car, "Leopard1A3");
		
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		
country(_("Norway"), "Norway", "NOR", "Norway.png", 12, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Vernedyktighetsmedaljen', _('Vernedyktighetsmedaljen'), 200,  'NOR-01-AirForceServiceMedal.png'),
    award('Forsvarets Medalje for Internasjonale Operasjoner', _('Forsvarets Medalje for Internasjonale Operasjoner'), 600,  'NOR-02-Armed_Forces_medal_for_international_operations.png'),
    award('Forsvarsmedaljen', _('Forsvarsmedaljen'), 1000, 'NOR-03-Armed_Forces_medal.png'),
    award('Forsvarsmedaljen m Laurbargren', _('Forsvarsmedaljen m Laurbargren'), 1400, 'NOR-04-Armed_Forces_medal_with_Laureat.png'),                  
    award('Krigskorset', _('Krigskorset'), 1800, 'NOR-05-War_Cross.png'),                                  
    award('St Olavsmedaljen', _('St Olavsmedaljen'), 2200, 'NOR-06-StOlaf_Medal.png'),
    award('Krigsmedaljen', _('Krigsmedaljen'), 2600, 'NOR-07-War_Medal.png'),                                
    award('Den kongelige Norske St Olavs orden', _('Den kongelige Norske St Olavs orden'), 3000, 'NOR-08-StOlaf_Knight.png'),                                                                            
  },                                         
  'Norway.lua',
  {0,270,64,30}
);

-- DENMARK
local units = {}
	copyTable(units,db.default_units)
			
        cnt_unit( units.Planes.Plane, "C-130");
        cnt_unit( units.Planes.Plane, "F-16A MLU");
		cnt_unit( units.Planes.Plane, "P-51D");
			
        cnt_unit( units.Cars.Car, "M-113");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "MLRS");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "M 818");
        cnt_unit( units.Cars.Car, "Leopard1A3");
		
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
			
country(_("Denmark"), "Denmark", "DEN", "Denmark.png", 13, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medaljen for udmarket lufttjeneste', _('Medaljen for udmarket lufttjeneste'), 200,  'DEN-01-Distinguished_Flying_Medal.png'),
    award('Dannebrogordenen Storkors', _('Dannebrogordenen Storkors'), 600,  'DEN-02-Silver_Cross_of_the_Order_of_Dannebrog.png'),
    award('Dannebrogordenen Ridderkors', _('Dannebrogordenen Ridderkors'), 1000, 'DEN-03-Order_of_Denneborg_Knight.png'),
    award('Dannebrogordenen Ridderkors af 1. grad', _('Dannebrogordenen Ridderkors af 1. grad'), 1400, 'DEN-04-Order_of_Danneburg_Knight_1st_Degree.png'),
    award('Hadertegnet for god tjeneste ved flyvevabnet', _('Hadertegnet for god tjeneste ved flyvevabnet'), 1800, 'DEN-05-Air_Force_Long_Service_Medal-25_years.png'),
    award('Forsvarets Medalje', _('Forsvarets Medalje'), 2200, 'DEN-06-Medal_of_the_Defence.png'),
    award('Dannebrogordenen Kommandorkors af 1. grad', _('Dannebrogordenen Kommandorkors af 1. grad'), 2600, 'DEN-07-Order_of_Danneburg_Commander_1st_Degree_Cross.png'),
    award('Forsvarets Medalje for Tapperhed', _('Forsvarets Medalje for Tapperhed'), 3000, 'DEN-08-Medal_for_Heroic_Deeds.png'),                       
  },                                         
  'Denmark.lua',
  {0,120,64,30}  
);

-- GEORGIA
local units = {}
	copyTable(units,db.default_units)

        cnt_unit( units.Planes.Plane, "Su-25");
        cnt_unit( units.Planes.Plane, "An-26B");
        cnt_unit( units.Planes.Plane, "Su-25T");
		cnt_unit( units.Planes.Plane, "L-39ZA");
		cnt_unit( units.Planes.Plane, "Yak-40");
		cnt_unit( units.Planes.Plane, "P-51D");
			
        cnt_unit( units.Ships.Ship, "ELNYA");
        cnt_unit( units.Ships.Ship, "ALBATROS");
        cnt_unit( units.Ships.Ship, "MOLNIYA");
        cnt_unit( units.Ships.Ship, "Dry-cargo ship-1");
        cnt_unit( units.Ships.Ship, "Dry-cargo ship-2");
        cnt_unit( units.Ships.Ship, "ZWEZDNY");
		
        cnt_unit( units.Cars.Car, "BTR-80");
        cnt_unit( units.Cars.Car, "Strela-1 9P31");
        cnt_unit( units.Cars.Car, "Strela-10M3");
        cnt_unit( units.Cars.Car, "ZSU-23-4 Shilka");
        cnt_unit( units.Cars.Car, "SA-11 Buk SR 9S18M1");
		cnt_unit( units.Cars.Car, "SA-11 Buk CC 9S470M1");
        cnt_unit( units.Cars.Car, "SA-11 Buk LN 9A310M1");
        cnt_unit( units.Cars.Car, "SAU Akatsia");
        cnt_unit( units.Cars.Car, "SAU 2-C9");
        cnt_unit( units.Cars.Car, "ATMZ-5");
        cnt_unit( units.Cars.Car, "ATZ-10");
        cnt_unit( units.Cars.Car, "Ural-4320 APA-5D");
        cnt_unit( units.Cars.Car, "BMD-1");
        cnt_unit( units.Cars.Car, "BMP-1");
        cnt_unit( units.Cars.Car, "BMP-2");
        cnt_unit( units.Cars.Car, "BRDM-2");
        cnt_unit( units.Cars.Car, "Grad-URAL");
        cnt_unit( units.Cars.Car, "UAZ-469");
        cnt_unit( units.Cars.Car, "Ural-375");
        cnt_unit( units.Cars.Car, "Ural-375 PBU");
        cnt_unit( units.Cars.Car, "IKARUS Bus");
        cnt_unit( units.Cars.Car, "VAZ Car");
        cnt_unit( units.Cars.Car, "Trolley bus");
        cnt_unit( units.Cars.Car, "KAMAZ Truck");
        cnt_unit( units.Cars.Car, "LAZ Bus");
        cnt_unit( units.Cars.Car, "GAZ-3307");
        cnt_unit( units.Cars.Car, "GAZ-3308");
        cnt_unit( units.Cars.Car, "GAZ-66");
        cnt_unit( units.Cars.Car, "MAZ-6303");
        cnt_unit( units.Cars.Car, "ZIL-4331");
        cnt_unit( units.Cars.Car, "Osa 9A33 ln");
        cnt_unit( units.Cars.Car, "SKP-11");
        cnt_unit( units.Cars.Car, "Ural ATsP-6");
        cnt_unit( units.Cars.Car, "ZiL-131 APA-80");
        cnt_unit( units.Cars.Car, "ZIL-131 KUNG");
        cnt_unit( units.Cars.Car, "ZU-23 Emplacement");
        cnt_unit( units.Cars.Car, "ZU-23 Emplacement Closed");
        cnt_unit( units.Cars.Car, "Ural-375 ZU-23");
        cnt_unit( units.Cars.Car, "Dog Ear radar");
        cnt_unit( units.Cars.Car, "1L13 EWR");
        cnt_unit( units.Cars.Car, "MTLB");
        cnt_unit( units.Cars.Car, "T-72B");
        cnt_unit( units.Cars.Car, "SA-18 Igla manpad");
        cnt_unit( units.Cars.Car, "SA-18 Igla comm");
        cnt_unit( units.Cars.Car, "T-55");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "Soldier AK");
        cnt_unit( units.Cars.Car, "Soldier RPG");
        cnt_unit( units.Cars.Car, "5p73 s-125 ln");
        cnt_unit( units.Cars.Car, "snr s-125 tr");
        cnt_unit( units.Cars.Car, "p-19 s-125 sr");
		cnt_unit( units.Cars.Car, "M 818");
		cnt_unit( units.Cars.Car, "2B11 mortar");

        cnt_unit( units.Helicopters.Helicopter, "UH-1H");
        cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
        cnt_unit( units.Helicopters.Helicopter, "Mi-24V");
		
country(_("Georgia"), "Georgia", "GRG", "Georgia.png", 16, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medali "Sabrdzolo Damsakhurebisatvis"', _('Medali "Sabrdzolo Damsakhurebisatvis"'), 200,  'GR-01-Medal_for_the_Service_in_Battle.png'),
    award('Medali "Mkhedruli Mamatsobisatvis"', _('Medali "Mkhedruli Mamatsobisatvis"'), 600,  'GR-02-Medal_for_Military_Courage.png'),
    award('Vakhtang Gorgasalis Ordeni III', _('Vakhtang Gorgasalis Ordeni III'), 1000, 'GR-03-Order_of_Vakhtang_Gorgasali_III.png'),
    award('Vakhtang Gorgasalis Ordeni II', _('Vakhtang Gorgasalis Ordeni II'), 1400, 'GR-04-Order_of_Vakhtang_Gorgasali_II.png'),
    award('Vakhtang Gorgasalis Ordeni I', _('Vakhtang Gorgasalis Ordeni I'), 1800, 'GR-05-Order_of_Vakhtang_Gorgasali_I.png'),
    award('Girsebis Ordeni', _('Girsebis Ordeni'), 2200, 'GR-06-Order_of_Honour.png'),
    award('Girsebis Medali', _('Girsebis Medali'), 2600, 'GR-07-Medal_of_Valour.png'),
    award('Okros Satsmisis Ordeni', _('Okros Satsmisis Ordeni'), 3000, 'GR-08-Order_of_the_Gold_Fleece.png'),       
  },                                         
  'Georgia.lua',
  {0,180,64,30}
);

-- ISRAEL
local units = {}
	copyTable(units,db.default_units)

        cnt_unit( units.Planes.Plane, "F-15C");
        cnt_unit( units.Planes.Plane, "F-15E");
        cnt_unit( units.Planes.Plane, "F-16C bl.52d");
        cnt_unit( units.Planes.Plane, "C-130");
        cnt_unit( units.Planes.Plane, "F-4E");
		cnt_unit( units.Planes.Plane, "P-51D");
			
        cnt_unit( units.Cars.Car, "M-113");
        cnt_unit( units.Cars.Car, "M1097 Avenger");
        cnt_unit( units.Cars.Car, "Patriot str");
        cnt_unit( units.Cars.Car, "Patriot ln");
		cnt_unit( units.Cars.Car, "Patriot AMG");
		cnt_unit( units.Cars.Car, "Patriot EPP");
		cnt_unit( units.Cars.Car, "Patriot ECS");
        cnt_unit( units.Cars.Car, "Patriot cp");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "Vulcan");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "LAV-25");
        cnt_unit( units.Cars.Car, "AAV7");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "M-60");
        cnt_unit( units.Cars.Car, "M 818");
        cnt_unit( units.Cars.Car, "M48 Chaparral");
        cnt_unit( units.Cars.Car, "MLRS");
        cnt_unit( units.Cars.Car, "Stinger manpad dsr");
        cnt_unit( units.Cars.Car, "Stinger comm dsr");
		
        cnt_unit( units.Helicopters.Helicopter, "AH-64A");
        cnt_unit( units.Helicopters.Helicopter, "AH-1W");
        cnt_unit( units.Helicopters.Helicopter, "UH-60A");
        cnt_unit( units.Helicopters.Helicopter, "AH-64D");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
			
country(_("Israel"), "Israel", "ISR", "Israel.png", 15, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('ITUR HAGVURA', _('ITUR HAGVURA'), 1000,  'Distinguished_Service_Medal.png'),
    award([[ITUR HA'OZ]], _([[ITUR HA'OZ]]), 2000,  'Gallantry_Medal.png'),
    award('ITUR HAMOFET', _('ITUR HAMOFET'), 3000,  'Valor_Medal.png'),                
  },                                         
  'Israel.lua',
  {0,240,64,30} 
);

-- INSURGENTS
local units = {}
	copyTable(units,db.default_units)
    units.Helicopters.Helicopter = {}
    units.Planes.Plane = {}
	
		cnt_unit( units.Planes.Plane, "P-51D");

        cnt_unit( units.Ships.Ship, "ELNYA");
        cnt_unit( units.Ships.Ship, "MOLNIYA");
        cnt_unit( units.Ships.Ship, "Dry-cargo ship-1");
        cnt_unit( units.Ships.Ship, "Dry-cargo ship-2");
        cnt_unit( units.Ships.Ship, "ZWEZDNY");
			
        cnt_unit( units.Cars.Car, "BTR-80");
        cnt_unit( units.Cars.Car, "Strela-1 9P31");
        cnt_unit( units.Cars.Car, "Strela-10M3");
        cnt_unit( units.Cars.Car, "ZSU-23-4 Shilka");
        cnt_unit( units.Cars.Car, "SAU Akatsia");
        cnt_unit( units.Cars.Car, "SAU 2-C9");
        cnt_unit( units.Cars.Car, "ATMZ-5");
        cnt_unit( units.Cars.Car, "ATZ-10");
        cnt_unit( units.Cars.Car, "BMD-1");
        cnt_unit( units.Cars.Car, "BMP-1");
        cnt_unit( units.Cars.Car, "BMP-2");
        cnt_unit( units.Cars.Car, "BRDM-2");
        cnt_unit( units.Cars.Car, "Grad-URAL");
        cnt_unit( units.Cars.Car, "UAZ-469");
        cnt_unit( units.Cars.Car, "Ural-375");
        cnt_unit( units.Cars.Car, "Ural-375 PBU");
        cnt_unit( units.Cars.Car, "IKARUS Bus");
        cnt_unit( units.Cars.Car, "VAZ Car");
        cnt_unit( units.Cars.Car, "Trolley bus");
        cnt_unit( units.Cars.Car, "KAMAZ Truck");
        cnt_unit( units.Cars.Car, "LAZ Bus");
        cnt_unit( units.Cars.Car, "GAZ-3307");
        cnt_unit( units.Cars.Car, "GAZ-3308");
        cnt_unit( units.Cars.Car, "GAZ-66");
        cnt_unit( units.Cars.Car, "MAZ-6303");
        cnt_unit( units.Cars.Car, "ZIL-4331");
        cnt_unit( units.Cars.Car, "ZU-23 Insurgent");
        cnt_unit( units.Cars.Car, "ZU-23 Closed Insurgent");
        cnt_unit( units.Cars.Car, "Ural-375 ZU-23 Insurgent");
        cnt_unit( units.Cars.Car, "ZiL-131 APA-80");
        cnt_unit( units.Cars.Car, "ZIL-131 KUNG");
        cnt_unit( units.Cars.Car, "MTLB");
        cnt_unit( units.Cars.Car, "SA-18 Igla manpad");
        cnt_unit( units.Cars.Car, "SA-18 Igla comm");
        cnt_unit( units.Cars.Car, "T-55");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "Soldier AK");
        cnt_unit( units.Cars.Car, "Soldier RPG");
		cnt_unit( units.Cars.Car, "2B11 mortar");
			
        cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
			
country(_("Insurgents"), "Insurgents", "INS", "Insurgents.png", 17, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
  },                                         
  'Insurgents.lua',
  {0,450,64,30} 
);

-- ABKHAZIA
local units = {}
	copyTable(units,db.default_units)
    units.Helicopters.Helicopter = {}
    units.Planes.Plane = {}

		cnt_unit( units.Planes.Plane, "Su-25");
        cnt_unit( units.Planes.Plane, "An-26B");
		cnt_unit( units.Planes.Plane, "L-39ZA");
		cnt_unit( units.Planes.Plane, "P-51D");

        cnt_unit( units.Ships.Ship, "ELNYA");
        cnt_unit( units.Ships.Ship, "MOLNIYA");
        cnt_unit( units.Ships.Ship, "ZWEZDNY");
        cnt_unit( units.Ships.Ship, "Dry-cargo ship-1");
        cnt_unit( units.Ships.Ship, "Dry-cargo ship-2");

        cnt_unit( units.Cars.Car, "BTR-80");
        cnt_unit( units.Cars.Car, "SA-11 Buk SR 9S18M1");
		cnt_unit( units.Cars.Car, "SA-11 Buk CC 9S470M1");
        cnt_unit( units.Cars.Car, "SA-11 Buk LN 9A310M1");
        cnt_unit( units.Cars.Car, "Kub 1S91 str");
        cnt_unit( units.Cars.Car, "Kub 2P25 ln");
        cnt_unit( units.Cars.Car, "Osa 9A33 ln");
        cnt_unit( units.Cars.Car, "Strela-10M3");
        cnt_unit( units.Cars.Car, "Dog Ear radar");
        cnt_unit( units.Cars.Car, "ZSU-23-4 Shilka");
        cnt_unit( units.Cars.Car, "SAU Akatsia");
        cnt_unit( units.Cars.Car, "SAU 2-C9");
        cnt_unit( units.Cars.Car, "ATMZ-5");
        cnt_unit( units.Cars.Car, "ATZ-10");
        cnt_unit( units.Cars.Car, "BMD-1");
        cnt_unit( units.Cars.Car, "BMP-1");
        cnt_unit( units.Cars.Car, "BMP-2");
        cnt_unit( units.Cars.Car, "BRDM-2");
        cnt_unit( units.Cars.Car, "Grad-URAL");
        cnt_unit( units.Cars.Car, "UAZ-469");
        cnt_unit( units.Cars.Car, "Ural-375");
        cnt_unit( units.Cars.Car, "Ural-375 PBU");
        cnt_unit( units.Cars.Car, "IKARUS Bus");
        cnt_unit( units.Cars.Car, "VAZ Car");
        cnt_unit( units.Cars.Car, "Trolley bus");
        cnt_unit( units.Cars.Car, "KAMAZ Truck");
        cnt_unit( units.Cars.Car, "LAZ Bus");
        cnt_unit( units.Cars.Car, "SAU Gvozdika");
        cnt_unit( units.Cars.Car, "BTR_D");
        cnt_unit( units.Cars.Car, "GAZ-3307");
        cnt_unit( units.Cars.Car, "GAZ-3308");
        cnt_unit( units.Cars.Car, "GAZ-66");
        cnt_unit( units.Cars.Car, "ZIL-4331");
        cnt_unit( units.Cars.Car, "MAZ-6303");
        cnt_unit( units.Cars.Car, "SKP-11");
        cnt_unit( units.Cars.Car, "Ural-4320T");
        cnt_unit( units.Cars.Car, "Ural ATsP-6");
        cnt_unit( units.Cars.Car, "ZiL-131 APA-80");
        cnt_unit( units.Cars.Car, "ZIL-131 KUNG");
        cnt_unit( units.Cars.Car, "Ural-4320 APA-5D");
        cnt_unit( units.Cars.Car, "ZU-23 Emplacement");
        cnt_unit( units.Cars.Car, "ZU-23 Emplacement Closed");
        cnt_unit( units.Cars.Car, "Ural-375 ZU-23");
        cnt_unit( units.Cars.Car, "2S6 Tunguska");
        cnt_unit( units.Cars.Car, "Strela-1 9P31");
        cnt_unit( units.Cars.Car, "MTLB");
        cnt_unit( units.Cars.Car, "T-72B");
        cnt_unit( units.Cars.Car, "SA-18 Igla manpad");
        cnt_unit( units.Cars.Car, "SA-18 Igla comm");
        cnt_unit( units.Cars.Car, "T-55");
		cnt_unit( units.Cars.Car, "2B11 mortar");
		
        cnt_unit( units.Helicopters.Helicopter, "Mi-24V");
        cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "Ka-50");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
		
country(_("Abkhazia"), "Abkhazia", "ABH", "Abkhazia.png", 18, units,
  {
    callsign(1, "{63F96C45-0053-4b82-91A3-484E101297C7}", "0"),
    callsign(2, "{99614DB6-5B25-465e-87BC-528CFB253784}", "1"),
    callsign(3, "{AC5C879B-E065-40fe-B160-0CDAE7FC011D}", "2"),
    callsign(4, "{99420485-7146-4286-9CB4-B6E362A13F8B}", "3"),
    callsign(5, "{A72AF054-195F-431c-978D-B519ACAFD997}", "4"),
    callsign(6, "{B2B919BB-55E4-4731-8AC1-CFDB14341407}", "5"),
    callsign(7, "{7FCB6479-44DB-42c2-9EC4-9F7197A06F79}", "6"),
    callsign(8, "{1C2F8D53-DDD8-41d8-A871-A7BAF1E957F5}", "7"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medal for Bravery', _('Medal for Bravery'), 400,  'ABH-01-Bravery.png'),
    award('Orden Leon', _('Orden "Leon"'), 1800,  'ABH-02-Leon.png'),
    award('Orden Glory III', _('Orden "Akhdz Apsha"'), 2600, 'ABH-03-Glory-III.png'),
    award('Hero of Abkhazia', _('Hero of Abkhazia'), 3000, 'ABH-04-Hero.png'),                                                       
  },                                         
  'Abkhazia.lua',
  {0,480,64,30}
);

-- SOUTH OSSETIA
local units = {}
	copyTable(units,db.default_units)
    units.Helicopters.Helicopter = {}
    units.Planes.Plane = {}
    units.Ships.Ship = {}
	
        cnt_unit( units.Cars.Car, "BTR-80");
        cnt_unit( units.Cars.Car, "Osa 9A33 ln");
        cnt_unit( units.Cars.Car, "Strela-10M3");
        cnt_unit( units.Cars.Car, "ZSU-23-4 Shilka");
        cnt_unit( units.Cars.Car, "SAU Akatsia");
        cnt_unit( units.Cars.Car, "SAU 2-C9");
        cnt_unit( units.Cars.Car, "ATMZ-5");
        cnt_unit( units.Cars.Car, "ATZ-10");
        cnt_unit( units.Cars.Car, "BMD-1");
        cnt_unit( units.Cars.Car, "BMP-1");
        cnt_unit( units.Cars.Car, "BMP-2");
        cnt_unit( units.Cars.Car, "BRDM-2");
        cnt_unit( units.Cars.Car, "Grad-URAL");
        cnt_unit( units.Cars.Car, "UAZ-469");
        cnt_unit( units.Cars.Car, "Ural-375");
        cnt_unit( units.Cars.Car, "Ural-375 PBU");
        cnt_unit( units.Cars.Car, "IKARUS Bus");
        cnt_unit( units.Cars.Car, "VAZ Car");
        cnt_unit( units.Cars.Car, "KAMAZ Truck");
        cnt_unit( units.Cars.Car, "LAZ Bus");
        cnt_unit( units.Cars.Car, "SAU Gvozdika");
        cnt_unit( units.Cars.Car, "BTR_D");
        cnt_unit( units.Cars.Car, "GAZ-3307");
        cnt_unit( units.Cars.Car, "GAZ-3308");
        cnt_unit( units.Cars.Car, "GAZ-66");
        cnt_unit( units.Cars.Car, "ZIL-4331");
        cnt_unit( units.Cars.Car, "MAZ-6303");
        cnt_unit( units.Cars.Car, "SKP-11");
        cnt_unit( units.Cars.Car, "Ural-4320T");
        cnt_unit( units.Cars.Car, "Ural ATsP-6");
        cnt_unit( units.Cars.Car, "ZiL-131 APA-80");
        cnt_unit( units.Cars.Car, "ZIL-131 KUNG");
        cnt_unit( units.Cars.Car, "Ural-4320 APA-5D");
        cnt_unit( units.Cars.Car, "ZU-23 Emplacement");
        cnt_unit( units.Cars.Car, "ZU-23 Emplacement Closed");
        cnt_unit( units.Cars.Car, "Ural-375 ZU-23");
        cnt_unit( units.Cars.Car, "2S6 Tunguska");
        cnt_unit( units.Cars.Car, "Strela-1 9P31");
        cnt_unit( units.Cars.Car, "MTLB");
        cnt_unit( units.Cars.Car, "T-72B");
        cnt_unit( units.Cars.Car, "SA-18 Igla manpad");
        cnt_unit( units.Cars.Car, "SA-18 Igla comm");
        cnt_unit( units.Cars.Car, "T-55");
		cnt_unit( units.Cars.Car, "2B11 mortar");

        cnt_unit( units.Helicopters.Helicopter, "Mi-24V");
        cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "Ka-50");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
			
country(_("South Ossetia"), "South Ossetia", "RSO", "South Ossetia.png", 19, units,
  {
    callsign(1, "{63F96C45-0053-4b82-91A3-484E101297C7}", "0"),
    callsign(2, "{99614DB6-5B25-465e-87BC-528CFB253784}", "1"),
    callsign(3, "{AC5C879B-E065-40fe-B160-0CDAE7FC011D}", "2"),
    callsign(4, "{99420485-7146-4286-9CB4-B6E362A13F8B}", "3"),
    callsign(5, "{A72AF054-195F-431c-978D-B519ACAFD997}", "4"),
    callsign(6, "{B2B919BB-55E4-4731-8AC1-CFDB14341407}", "5"),
    callsign(7, "{7FCB6479-44DB-42c2-9EC4-9F7197A06F79}", "6"),
    callsign(8, "{1C2F8D53-DDD8-41d8-A871-A7BAF1E957F5}", "7"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Defender of the Fatherland', _('Defender of the Fatherland'), 1800,  'SOS-01-Defenders_of_the_Fatherland.png'),
    award('Uatsamonga', _('Hero of Osetia'), 3000, 'SOS-02-Uatsamonga.png'),                                                       
  },                                         
  'South Ossetia.lua',
  {0,510,64,30}
);

-- ITALY
local units = {}
	copyTable(units,db.default_units)
			
        cnt_unit( units.Planes.Plane, "C-130");
        cnt_unit( units.Planes.Plane, "F-16A MLU");
		cnt_unit( units.Planes.Plane, "P-51D");
		cnt_unit( units.Planes.Plane, "Tornado IDS");
			
        cnt_unit( units.Cars.Car, "M-113");
        cnt_unit( units.Cars.Car, "Hawk sr");
        cnt_unit( units.Cars.Car, "Hawk tr");
        cnt_unit( units.Cars.Car, "Hawk ln");
        cnt_unit( units.Cars.Car, "Hummer");
        cnt_unit( units.Cars.Car, "M-109");
        cnt_unit( units.Cars.Car, "MLRS");
        cnt_unit( units.Cars.Car, "Stinger manpad");
        cnt_unit( units.Cars.Car, "Stinger comm");
        cnt_unit( units.Cars.Car, "M 818");
        cnt_unit( units.Cars.Car, "Leopard1A3");
		cnt_unit( units.Cars.Car, "M978 HEMTT Tanker");
		cnt_unit( units.Cars.Car, "HEMTT TFFT");
		cnt_unit( units.Cars.Car, "M1043 HMMWV Armament");
		cnt_unit( units.Cars.Car, "M1045 HMMWV TOW");
		cnt_unit( units.Cars.Car, "2B11 mortar");
		
		cnt_unit( units.Helicopters.Helicopter, "Mi-8MT");
		cnt_unit( units.Helicopters.Helicopter, "UH-1H");
			
country(_("Italy"), "Italy", "ITA", "Italy.png", 20, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Commemorative Medal of Peace Operations', _('Commemorative Medal of Peace Operations'), 200,  'IT-01-Commemorative_Medal_of_Peace_Operations.png'),
    award('Honor Decoration Interforce', _('Honor Decoration Interforce'), 600,  'IT-02-Honor_Decoration_Interforce.png'),
    award('NATO Medal for Merits', _('NATO Medal for Merits'), 1000, 'IT-03-NATO_Medal_for_Merits.png'),
    award('Dannebrogordenen Ridderkors af 1. grad', _('Dannebrogordenen Ridderkors af 1. grad'), 1400, 'DEN-04-Order_of_Danneburg_Knight_1st_Degree.png'),
    award('Bronze Medal for Military Valour', _('Bronze Medal for Military Valour'), 1800, 'IT-04-Bronze_Medal_for_Military_Valour.png'),
    award('Silver Medal for Military Valor', _('Silver Medal for Military Valor'), 2200, 'IT-05-Silver_Medal_for_Military_Valor.png'),
    award('Cross of Aeronautical Merit Bronze', _('Cross of Aeronautical Merit Bronze'), 2600, 'IT-06-Cross_of_Aeronautical_Merit_Bronze.png'),
    award('Silver Cross of Merit Air Force', _('Silver Cross of Merit Air Force'), 3000, 'IT-07-Silver_Cross_of_Merit_Air_Force.png'),                       
	award('Gold Cros of Merit Aeronautical', _('Gold Cros of Merit Aeronautical'), 4000, 'IT-8-Gold_Cros_of_Merit_Aeronautical.png'),                       
  },                                         
  'Italy.lua',
  {0,540,64,30} 

);
  
  
-- Australia
local units = {}
	copyTable(units,db.default_units)

	cnt_unit( units.Planes.Plane, "C-130");
	cnt_unit( units.Planes.Plane, "P-51D");
	cnt_unit( units.Planes.Plane, "F/A-18C");
	
	cnt_unit( units.Cars.Car, "Leopard1A3");
	cnt_unit( units.Cars.Car, "Leopard-2");
	cnt_unit( units.Cars.Car, "Challenger2");
	cnt_unit( units.Cars.Car, "Hummer");
	cnt_unit( units.Cars.Car, "MLRS");
	cnt_unit( units.Cars.Car, "M-113");

	cnt_unit( units.Helicopters.Helicopter, "CH-47D");
	cnt_unit( units.Helicopters.Helicopter, "UH-1H");
	cnt_unit( units.Helicopters.Helicopter, "UH-60A");
		
country(_("Australia"), "Australia", "AUS", "Australia.png", 21, units,
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
    {
    rank('Second lieutenant', _('Pilot Officer'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('Flying Officer'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Flight Lieutenant'), 30, {0, 64, 64, 32}),
    rank('Major', _('Squadron Leader'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Wing Commander'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Group Captain'), 240, {0, 160, 64, 32}),
  },

  {
    award('Victoria Cross', _('Victoria Cross'), 3000, 'AUS01_Victoria_Cross.png'),
	award('Cross of Valour', _('Cross of Valour'),2600, 'AUS02_Cross_of_Valour.png'),
	award('Star of Gallantry', _('Star of Gallantry'), 2200, 'AUS03_The_Star_of_Gallantry.png'),
	award('Star of Courage', _('Star of Courage'), 1600, 'AUS04_Star_of_Courage.png'),    
    award('Distinguished Service Cross', _('Distinguished Service Cross'), 800, 'AUS05_Distinguished_Service_Cross.png'),
	
  },                                         
  'Australia.lua',
  {0,568,64,30}
);
